//
//  MCAnimationContext.h
//  ListView
//
//  Created by Mark Onyschuk on 13/05/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCViewAnimationProxy;

@interface MCAnimationContext : NSObject {
	NSMutableArray	*_animations;
	BOOL _isAnimating;
}

+ (id)currentContext;
+ (void)createNewContext;
+ (void)clearCurrentContext;

- (id)init;
- (void)dealloc;

- (void)addAnimationProxy:(MCViewAnimationProxy *)aProxy;
- (void)addSyncInterval:(NSTimeInterval)aTimeInterval;

- (void)run;

- (BOOL)isAnimating;

@end

typedef enum {
	MCProxyViewOperationNone,
	MCProxyViewOperationAddition,
	MCProxyViewOperationDeletion
} MCProxyViewOperation;

@interface MCViewAnimationProxy : NSProxy {
	NSView *_nonretainedView;
	NSDictionary *_animationDictionary;
	MCProxyViewOperation _viewOperation;
}

- (id)initWithView:(NSView *)aView;
- (void)dealloc;

- (NSDictionary *)animationDictionary;

- (MCProxyViewOperation)viewOperation;

- (void)doAnimationPreflight;
- (void)doAnimationPostflight;

- (void)setFrame:(NSRect)aRect;
- (void)addSubview:(NSView *)aView;
- (void)removeFromSuperview;

- (void)setHidden:(BOOL)aBool;

- (void)forwardInvocation:(NSInvocation *)anInvocation;
- (NSMethodSignature *)methodSignatureForSelector:(SEL)aSelector;

@end

@interface NSView (MCViewAnimationProxySupport) 
- (id)animationProxy;
@end
